/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class IpAddressListPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private JTable fTable;
    private LogoDrawing fLogoDrawing = (LogoDrawing)Application.getInstance().getActiveApplicationSurface().getEditor().getView().getModel();
    private String selectedIPAddress;

    public IpAddressListPanel() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel pane = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(pane);
        this.setLayout(new BorderLayout());
        this.add(scrollPane);
        JScrollPane tablePanel = new JScrollPane(this.getTable());
        tablePanel.setPreferredSize(new Dimension(100, 100));
        pane.add((Component)tablePanel, "Center");
    }

    private JTable getTable() {
        if (this.fTable == null) {
            Object[] fColumnName = new String[]{Language.getString("global.blockname", "Block name"), Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address")};
            DefaultTableModel model = new DefaultTableModel(fColumnName, 0);
            Vector bList = this.fLogoDrawing.getWiringDiagram().getBlocks();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (Block b : bList) {
                String address = "";
                String blockname = b.getNumberPrefix() + b.getNumber();
                if (b.getParameter() instanceof NetworkNodeParameter) {
                    NetworkNodeParameter nParameter = (NetworkNodeParameter)b.getParameter();
                    String string = address = nParameter == null ? "" : nParameter.getAddress();
                    if (!"".equals(address)) {
                        if (dataMap.containsKey(address)) {
                            dataMap.put(address, (String)dataMap.get(address) + ", " + blockname);
                        } else {
                            dataMap.put(address, blockname);
                        }
                    }
                }
                if (!(b.getParameter() instanceof SOutputParameter)) continue;
                SOutputParameter sParameter = (SOutputParameter)b.getParameter();
                String string = address = sParameter == null ? "" : sParameter.getAddress();
                if ("".equals(sParameter.getAddress())) continue;
                if (dataMap.containsKey(address)) {
                    dataMap.put(address, (String)dataMap.get(address) + ", " + blockname);
                    continue;
                }
                dataMap.put(address, blockname);
            }
            int i = 0;
            for (Map.Entry entry : dataMap.entrySet()) {
                model.insertRow(i, new Object[]{entry.getValue(), entry.getKey()});
                ++i;
            }
            this.fTable = new JTable(model){
                private static final long serialVersionUID = 1L;

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.fTable.setColumnSelectionAllowed(false);
            this.fTable.setSelectionMode(0);
            this.fTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2 && null != IpAddressListPanel.this.getOkButton()) {
                        IpAddressListPanel.this.setCurrentIpAddress();
                        IpAddressListPanel.this.getOkButton().doClick();
                    }
                }
            });
        }
        return this.fTable;
    }

    public void storeFieldContents() {
        this.setCurrentIpAddress();
    }

    private void setCurrentIpAddress() {
        int selectedRow = this.getTable().getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this.getTable().getModel().getRowCount()) {
            this.selectedIPAddress = (String)this.getTable().getModel().getValueAt(selectedRow, 1);
        }
    }

    public String getSelectedIPAddress() {
        if (this.selectedIPAddress == null) {
            this.selectedIPAddress = "";
        }
        return this.selectedIPAddress;
    }
}

